--- @meta

-- This file is autogenerated. Do not edit this file manually. Your changes will be ignored.
-- More information: https://github.com/MWSE/MWSE/tree/master/docs

--- A widget containing properties specific to color pickers.
--- @class tes3uiColorPicker : tes3uiWidget
--- @field alphaBar Image *Read-only*. The image used by the alpha bar.
--- @field alphaCheckerboard Image *Read-only*. The image used by the alpha bar.
--- @field currentAlpha number The currently selected alpha in the color picker.
--- @field currentColor ffiImagePixel The currently selected color in the color picker.
--- @field height integer *Read-only*. The height of the main, hue, and optionally alpha and saturation, pickers.
--- @field hueBar Image *Read-only*. The image used by the hue bar.
--- @field hueWidth integer *Read-only*. The width of pickers for hue, and optionally alpha and saturation.
--- @field initialAlpha number *Read-only*. The initial alpha value.
--- @field initialColor mwseColorTable *Read-only*. The initial color for the picker.
--- @field mainImage Image *Read-only*. The image used by the main picker.
--- @field mainWidth integer *Read-only*. The width of the main picker.
--- @field saturationBar Image *Read-only*. The image used by the saturation bar.
--- @field textures tes3uiColorPickerTextureTable A table with the textures used in the UI image elements that comprise the picker.
tes3uiColorPicker = {}

--- Changes the currently selected color. Updates current preview color, text input, saturation bar image and indicator positions.
--- @param newColor mwseColorTable|ffiImagePixel The new color to set.
--- @param alpha? number *Default*: `1`. Alpha value to set.
function tes3uiColorPicker:colorSelected(newColor, alpha) end

--- Gets the current alpha value.
--- @return number alpha No description yet available.
function tes3uiColorPicker:getAlpha() end

--- Gets the currently selected color.
--- @return mwseColorTable color No description yet available.
function tes3uiColorPicker:getColor() end

--- Gets the current color and alpha.
--- @return mwseColorTable color No description yet available.
--- @return number alpha No description yet available.
function tes3uiColorPicker:getColorAlpha() end

--- Gets the current RGB color in an array. Usually used to feed the color from the color picker straight to another UI element, e.g. `myElement.color = pickerElement.widget:getColorArray()`.
--- @return number[] arrayRGB No description yet available.
function tes3uiColorPicker:getColorArray() end

--- Gets the current color and alpha in a single table.
--- @return mwseColorATable color No description yet available.
function tes3uiColorPicker:getRGBA() end

--- Changes the currently selected color. It calls `self:colorSelected` and then updates the main picker image. Because of that, it's more expensive.
--- @param newColor mwseColorTable|ffiImagePixel The new color to set.
--- @param alpha? number *Default*: `1`. Alpha value to set.
function tes3uiColorPicker:hueChanged(newColor, alpha) end

